%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Moving Finite Line Source   (MFLSs): Molina et al. 2011                 %
% Steady state                                                            %
%                                                                         %
% Version July 2013           Nelson Molina-Giraldo Matrix Solutions Inc. %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_MFLScs(x,y,ro,z,H,lm,Cm,vT,t,QL,ax,ay)
%--Analytical solution----------------------------------------------------%
Dt = lm/Cm;             % thermal diffusivity [m2/s]

% Temperature change 
T = QL*(1/4/pi/lm)*besseli(0,vT*ro/2/Dt).*...
(quadv(@(ze) exp(-vT*sqrt(ro.^2+(z-ze)^2)/2/Dt)./sqrt(ro.^2+(z-ze)^2),0,H)-...
 quadv(@(ze) exp(-vT*sqrt(ro.^2+(z-ze)^2)/2/Dt)./sqrt(ro.^2+(z-ze)^2),-H,0));

%--Nomenclature-----------------------------------------------------------%
% x,y: x-y coordinates [m]
% ro: borehole radius [m]
% z: vertical coordinate [m]
% H: borehole length [m]
% lm: bulk thermal conductivity [W/m/K]
% Cm: volumetric heat capacity of the porous medium [J/m3/K] 
% vT: heat transport velocity [m/s]
% t: simulation time [s]
% QL : heat flow rate per unit length of borehole [W/m]
% ax: longitudinal thermal dispersivity 
% ay: transverse thermal dispersivity
% Please note that there are some variables which are not used in the 
% current subfunction. 